<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Facades\App;

/**
 * @property mixed $redirect_url
 * @property mixed $new_tab
 * @property mixed $content
 * @property mixed $placement
 * @property mixed $icon
 * @property mixed $path
 * @property mixed $title
 * @property mixed $name
 * @property mixed $basic_page
 * @property mixed $is_enabled
 * @property mixed $id
 * @method static wherePath($page)
 */
class Page extends Model
{
    use HasFactory;
    protected $table = 'pages';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'path',
        'title',
        'content',
        'is_enabled',
        'placement',
        'redirect_url',
    ];

    protected $casts = [
        'placement' => 'array',
    ];

    public function translate($locale = null): void
    {
        $locale = $locale ?: App::getLocale();
        $translation = $this->translations()->where('locale', $locale)->first();
        if ($translation) {
            $this->name = $translation->name;
            $this->title = $translation->title;
            $this->content = $translation->content;
        }
    }

    public function translations(): HasMany
    {
        return $this->hasMany(PageTranslation::class);
    }

    public static function getActive()
    {
        $pages = Page::whereIsEnabled(1)->get();
        foreach ($pages as $page) {
            $page->translate();
        }
        return $pages;
    }
}
