<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Model;

class OrderMember extends Model
{
    use HasFactory;

    protected $table = 'order_members';

    protected $fillable = [
        'order_id',
        'inviter_id',
        'user_id',
        'email',
        'status',
        'is_admin',
        'permissions'
    ];

    protected $casts = [
        'permissions' => 'array',
    ];

    public function getEmailAttribute()
    {
        return $this->user->email ?? $this->attributes['email'] ?? null;
    }

    public function hasPerm(string $routeOrPage): bool
    {
        if($this->is_admin) {
            return true;
        }

        $permissions = collect($this->permissions ?? []);
        return $permissions->has($routeOrPage);
    }

    public function inviter(): BelongsTo
    {
        return $this->belongsTo(User::class, 'inviter_id');
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function order(): BelongsTo
    {
        return $this->belongsTo(Order::class);
    }
}
