<?php

namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Facades\Theme;
use App\Models\Device;

class ReAuthenticationController extends Controller
{
    public function index(Request $request)
    {
        if(!Auth::user()->is_admin()) {
            return redirect()->route('dashboard')->withErrors('You don\'t have permissions to access this resource');
        }

        if(session('reauthenticated') !== NULL AND session('reauthenticated')) {
            return redirect($request->input('redirect'))->with('warning', 'You have already reauthenticated');
        }

        return Theme::view('reauthenticate', ['is_admin' => true, 'redirect' => $request->input('redirect')]);
    }

    public function reauthenticate(Request $request)
    {
        $credentials = $request->validate([
            'password' => ['required', 'string'],
        ]);

        if (Auth::attempt(['email' => Auth::user()->email, 'password' => $credentials['password']])) {
            session(['reauthenticated' => true]);
            return redirect()->intended($request->input('redirect'));
        }

        return redirect()->route('reauthenticate', ['redirect' => $request->input('redirect')])->withErrors(['password' => 'Invalid password']);
    }

    public function client(Request $request, Device $device)
    {
        if($device->user_id !== Auth::user()->id && !Auth::user()->is_admin())
        {
            return redirect()->back()->withErrors('You don\'t have permissions to access this resource');
        }
        
        if(!$device->is_revoked)
        {
            return redirect('/')->withErrors('Something went wrong');
        }

        return Theme::view('reauthenticate', ['is_admin' => false, 'device' => $device]);
    }

    public function clientPost(Request $request, Device $device)
    {
        if($device->user_id !== Auth::user()->id && !Auth::user()->is_admin())
        {
            return redirect()->back()->withErrors('You don\'t have permissions to access this resource');
        }

        $credentials = $request->validate([
            'password' => ['required', 'string'],
        ]);

        if (Auth::attempt(['email' => Auth::user()->email, 'password' => $credentials['password']])) {
           $device->revoke();
           return redirect('/')->withSuccess('Account has been unlocked');
        }

        return redirect()->back()->withErrors('Provided credentials do not exists within our record');
    }
}