<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Laravel\Socialite\Facades\Socialite;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Auth;
use App\Models\UserOauth;
use App\Models\ErrorLog;
use App\Models\Settings;
use App\Facades\Theme;

class OauthLoginController extends Controller
{
    public $service;

    public function __construct()
    {
        $this->service = request()->route('service');

        $services = ['github', 'discord', 'google'];
        if(!in_array($this->service, $services)) {
            return redirect()->back()->send();
        }

        $this->setConfig();
    }

    public function connect()
    {
        try {
            return Socialite::driver($this->service)->redirect();
        } catch(\Exception $error) {
            ErrorLog::catch('oauth::connect::'. $this->service, $error->getMessage());
            return redirect()->route('login')->withError("Authentication Failed: Please contact an Administrator, errors have been logged.");
        }
    }

    public function callback()
    {
        try {
            $user = Socialite::driver($this->service)->user();

            dd($user);

        } catch(\Exception $error) {
            ErrorLog::catch('oauth::callback::'. $this->service, $error->getMessage());
            return redirect()->route('login')->withError("Something went wrong, please try again.");
        }
    }

    protected function setConfig()
    {
        config(['services.'.$this->service.'.client_id' => Settings::getJson('oauth::'. $this->service, 'client_id')]);
        config(['services.'.$this->service.'.client_secret' => Settings::getJson('oauth::'. $this->service, 'client_secret')]);
        config(['services.'.$this->service.'.redirect' => config('app.url') . '/oauth/'.$this->service.'/redirect']);
    }

}
