<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use App\Facades\AdminTheme as Theme;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Cache;

class UpdatesController extends Controller
{
    protected string $version_api = 'https://wemx.net/api/wemx/versions';

    public function index()
    {
        return redirect()->back()->withError('This page has been disabled');

        $response = Http::acceptJson()->get($this->version_api);
        if($response->failed()) {
            return redirect('/admin')->withError(__('admin.failed_connect_remove_server_please_try_again'));
        }

        $versions = $response->object();
        $latest_version = $versions[0];

        return Theme::view('updates', compact('versions', 'latest_version'));
    }

    public function install($version, $type = 'stable')
    {
        $license = settings('encrypted::license_key');
        Artisan::queue('wemx:update', ['license_key' => $license, '--type' => $type, '--ver' => $version]);

        Cache::put('app_updating', [
            'updating' => true,
            'version' => $version,
            'type' => $type,
            'progress' => __('admin.preparing_for_installation'),
        ], 120);

        return redirect()->route('updates.index')->with(['success' => __('admin.installation_started_please_wait')]);
    }

    public function trackProgress()
    {
        return Cache::get('app_updating', ['updating' => false]);
    }

    public function cancelUpdate()
    {
        return Cache::forget('app_updating');
    }
}
