<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Facades\Theme;
use App\Http\Controllers\Controller;

class ReAuthenticationController extends Controller
{


    public function showReAuthenticationForm()
    {
        return Theme::view('reauthenticate');
    }

    public function reauthenticate(Request $request)
    {
        $credentials = $request->validate([
            'password' => ['required', 'string'],
        ]);

        if (Auth::attempt(['email' => Auth::user()->email, 'password' => $credentials['password']])) {
            session(['reauthenticated' => true]);
            return redirect()->intended('/admin');
        }

        return redirect()->back()->withErrors(['password' => 'Invalid password']);
    }
}
