<?php

namespace App\Http\Controllers\Admin;

use App\Entities\ResourceApiClient;
use App\Http\Controllers\Controller;
use App\Facades\AdminTheme as Theme;
use Illuminate\Support\Facades\Artisan;
use Nwidart\Modules\Facades\Module;

class ModulesController extends Controller
{
    // return login page view
    public function index()
    {
        $api = new ResourceApiClient;
        $marketplace = $api->getAllResources('Modules');
        if (array_key_exists('error', $marketplace)) {
            $marketplace = [];
        }
        return Theme::view('modules.index', compact('marketplace'));
    }

    public function toggleStatus($module)
    {
        $module = Module::find($module);

        if (!$module) {
            return redirect()->back()->with('error',
                trans('responses.module_toggle_error', ['default' => 'Specified module does not exist or has been deleted.'])
            );
        }

        if ($module->isEnabled()) {
            $module->disable();
            return redirect()->back()->with('warning',
                trans('responses.module_toggle_warning', ['module' => $module->getName(), 'default' => 'Module :module has been disabled'])
            );
        }
        Artisan::queue('module:update', ['module' => $module->getName()]);
        $module->enable();
        Artisan::call('module:update', ['module' => $module->getName()]);
        return redirect()->back()->with('success',
            trans('responses.module_toggle_success', ['module' => $module->getName(), 'default' => 'Module :module has been enabled'])
        );
    }
}
