<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use App\Jobs\SendWebhook;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // cron tasks
        $schedule->command('cron:emails:send')->everyFiveSeconds()->withoutOverlapping();
        $schedule->command('queue:start')->everyMinute()->withoutOverlapping();

        $schedule->command('subscriptions:check')->hourly();
        $schedule->command('cron:orders:suspend-expired')->hourly();
        $schedule->command('cron:orders:terminate-suspended')->hourly();
        $schedule->command('cron:payments:delete-expired')->hourly();
        $schedule->command('permissions:save')->everyMinute();
        $schedule->command('user:remove-requested')->everyMinute();

        // packages
        $schedule->command('cloudflare:reload')->daily();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
