<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class QueueWorker extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'queue:start';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Restart the queue worker and start it';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // Stop any running queue workers
        Artisan::call('queue:restart');

        sleep(3);

        // Start a new queue worker
        Artisan::call('queue:work', [
            '--max-time' => 60,
        ]);

        $this->info('Queue worker restarted successfully.');
    }
}
