<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class CheckOrders extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'orders:check';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check and update orders statuses';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $orders = Order::where('expires_at', '<', now())->get();
        $this->info("Found {$orders->count()} to check");
        $orders->each(function ($order) {
            $payments = Payment::where('type', '!=', 'subscription')->whereStatus('paid')->whereOrderId($order->id)->get();
            $payments->each(function ($payment) use ($order) {
                $service = new $payment->service_handler;
                $service->onCancel($payment);
                Order::find($order->id)->update(['status' => 'deactive', 'cancelled_at' => now()]);
                Payment::find($payment->id)->update(['status' => 'unpaid']);
                $this->warn("Order with ID: {$order->id} has been canceled due to non-payment");
            });
        });
    }
}
